/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (29/05/07)
 */    
package com.ejie.p06b.util;

//import java.text.DecimalFormat;

import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BErrores;



/**
 * Esta clase representa un conjunto de mtodos para utilidades varias.
 */
public class P06BUtil {
	
	public static void main(String[] args){
		String base64 = P06BUtil.toBase64("ejemplo base 64");
		System.out.println("Ejemplo:"+base64);
		String normal = P06BUtil.fromBase64(base64);
		System.out.println("Normal:"+normal);
		try{
			/*
			System.out.println("12345: " + P06BUtil.normalizaNumConDecimales("12345"));
			System.out.println("12345,: " + P06BUtil.normalizaNumConDecimales("12345,"));
			System.out.println("12345,6: " + P06BUtil.normalizaNumConDecimales("12345,6"));
			System.out.println("12345,67: " + P06BUtil.normalizaNumConDecimales("12345,67"));
			System.out.println("12345,678: " + P06BUtil.normalizaNumConDecimales("12345,678"));
			System.out.println("1.23.45,67: " + P06BUtil.normalizaNumConDecimales("1.23.45,67"));
			System.out.println("12345,.2: " + P06BUtil.normalizaNumConDecimales("12345,.2"));
			System.out.println("0012345,6: " + P06BUtil.normalizaNumConDecimales("0012345,6"));
			System.out.println("0,0: " + P06BUtil.normalizaNumConDecimales("0,0"));
			System.out.println("00,0: " + P06BUtil.normalizaNumConDecimales("00,0"));
			System.out.println("-0,1: " + P06BUtil.normalizaNumConDecimales("-0,1"));
			System.out.println("-560,95: " + P06BUtil.normalizaNumConDecimales("-560,95"));
			System.out.println("-5601234,95: " + P06BUtil.normalizaNumConDecimales("-5601234,95"));
			
			System.out.println("-560.9499999999999 REDONDEAR 2 dec: " + P06BUtil.redondear(-560.9499999999999, 2));
			
			System.out.println("prueba suma directa con doubles: " + (12345678.9 + 1000000.06));
			
			double aa = 12345678999.9;
			double bb = 100000011.06;
			double cc = aa + bb;
			DecimalFormat decimalFormat = new DecimalFormat("####.####");
			
			System.out.println(decimalFormat.format(cc));
			*/
			
			
		}catch(Exception e){
			
		}
		
	}
	
	/**
	 * @param numeroDesnormalizado: El nmero que nos llega sin formato nnn.nnn.nnn,dd
	 * @param numDec: Nmero al que se desea acotar la parte decimal 
	 * 				  0 si no la hubiera
	 * 
	 * return String -> Nmero normalizado a la forma nnn.nnn.nnn,dd
	 */
	public static String normalizaNumero(String numeroDesnormalizado, int numDec) throws P06BException{
		 String result = "";
		 String parteEntera="";
		 String parteDec="";
		 	
		try{
			if(numeroDesnormalizado==null || !P06BUtil.isNumero(numeroDesnormalizado))
				return numeroDesnormalizado;
			if(numeroDesnormalizado.indexOf(",")!=-1){
				//Tiene decimales
				//Luego Acorto parte decimal al valor de decimales que me venga
				parteDec = numeroDesnormalizado.substring(numeroDesnormalizado.indexOf(",")+1,numeroDesnormalizado.length());
				if(parteDec.length()>numDec)
					parteDec = numeroDesnormalizado.substring(numeroDesnormalizado.indexOf(",")+1,(numeroDesnormalizado.indexOf(",")+(numDec)+1));
			}
			//Obtengo parte entera del numero sin puntos
			//En result tengo el numero con 2 decimales
			//Quito los . por si hay algn punto colado
			result = numeroDesnormalizado.replaceAll("\\.","");
			if(numeroDesnormalizado.indexOf(",")!=-1)
				parteEntera = result.substring(0,(result.indexOf(",")));
			else
				parteEntera = result;
			//Pongo los puntos que corresponda a la parte entera
			if(parteEntera.length()>3){
				int primeros = Math.round(parteEntera.length()/3);
				int posPunto = parteEntera.length()-3;
				for(int i=0;i<primeros;i++){
					if(posPunto>0){
						parteEntera = parteEntera.substring(0,posPunto)+"."+parteEntera.substring(posPunto,parteEntera.length());
						posPunto=posPunto-3;
					}
				}
			}
			//Uno parte entera + parte decimal
			if(parteDec.equals(""))
				result = parteEntera;
			else
				result = parteEntera + "," +parteDec;
		}catch (Exception e) {
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0010);
	    }  
		return result;
	}
	
	
	/**
	 * El mtodo normalizaNumero, si se le pasa por ejemplo 50, devuelve 50, este mtodo devolvera siempre con decimales, por ejemplo 50,00
	 * Este mtodo SIEMPRE normaliza a 2 decimales
	 * @param numeroDesnormalizado: El nmero que nos llega sin formato nnn.nnn.nnn,dd
	 * 
	 * return String -> Nmero normalizado a la forma nnn.nnn.nnn,dd
	 */
	public static String normalizaNumConDecimales(String numeroDesnormalizado) throws P06BException{
		 String result = "";
		 String parteEntera="";
		 String parteDec="";
		 String signo = "";
		 	
		try{
			if(numeroDesnormalizado==null || !P06BUtil.isNumero(numeroDesnormalizado))
				return numeroDesnormalizado;
			if(numeroDesnormalizado.startsWith("-")){
				signo = "-";
				numeroDesnormalizado = numeroDesnormalizado.substring(1, numeroDesnormalizado.length());
			}
			if(numeroDesnormalizado.indexOf(",")!=-1){
				//Tiene decimales
                if (numeroDesnormalizado.indexOf(",") == (numeroDesnormalizado.length()-1))
                {   //Viene solo la coma, sin ningn decimal
                    parteDec = "00";
                }else if ((numeroDesnormalizado.indexOf(",") + 1) == (numeroDesnormalizado.length()-1)){
                    //Viene la coma y 1 solo decimal
                    parteDec = numeroDesnormalizado.substring(numeroDesnormalizado.indexOf(",") + 1, numeroDesnormalizado.indexOf(",") + 1 + 1);
                }else if ((numeroDesnormalizado.indexOf(",") + 2) <= (numeroDesnormalizado.length()-1)){
                    //Viene la coma y 2 o mas decimales, cogemos los dos primeros
                    parteDec = numeroDesnormalizado.substring(numeroDesnormalizado.indexOf(",") + 1, numeroDesnormalizado.indexOf(",") + 1 + 2);
                }

                //Por si en la parte decimal viniera alguna coma o punto en lugar de numero, la borramos                   
                parteDec = parteDec.replaceAll(",", "");
                parteDec = parteDec.replaceAll("\\.", "");
                
                if(parteDec.length() == 0)
                	parteDec = "00";
                else if(parteDec.length() == 1)
                	parteDec += "0";
			
			}
			//Obtengo parte entera del numero sin puntos
			//En result tengo el numero con 2 decimales
			//Quito los . por si hay algn punto colado
			result = numeroDesnormalizado.replaceAll("\\.","");
			if(numeroDesnormalizado.indexOf(",")!=-1)
				parteEntera = result.substring(0,(result.indexOf(",")));
			else
				parteEntera = result;
			
			while(parteEntera.startsWith("0") && parteEntera.length()>1){
				parteEntera = parteEntera.substring(1, parteEntera.length());
			}
			
			//Pongo los puntos que corresponda a la parte entera
			if(parteEntera.length()>3){
				int primeros = Math.round(parteEntera.length()/3);
				int posPunto = parteEntera.length()-3;
				for(int i=0;i<primeros;i++){
					if(posPunto>0){
						parteEntera = parteEntera.substring(0,posPunto)+"."+parteEntera.substring(posPunto,parteEntera.length());
						posPunto=posPunto-3;
					}
				}
			}
			
			//Uno parte entera + parte decimal
			if(parteDec.equals(""))
				result = signo + parteEntera + ",00";
			else
				result = signo + parteEntera + "," +parteDec;
		}catch (Exception e) {
			throw new P06BException(new Exception(e),P06BErrores.P06B_ERROR_0010);
	    }  
		return result;
	}
	
		
	/**
	 * @param cadena a examinar si es numrica
	 * 
	 * return boolean -> true si es nmero
	 */
	public static boolean isNumero(String cadena) throws P06BException{
		String cadenaTemp = cadena.replaceAll("\\.","");
		cadenaTemp = cadenaTemp.replaceAll(",","");
		try{
			Long.parseLong(cadenaTemp);
		}catch (Exception e){
			return false;
		}
		return true;
	}
	
	public static String toBase64(String normal){
		byte[] buf = null;
		String s = "";
		try {
	        // Convert a byte array to base64 string
	        buf = normal.getBytes();
	        s = new sun.misc.BASE64Encoder().encode(buf);
	    } catch (Exception e) {
	    }

		return s;
	}
	
	public static String fromBase64(String base64){
		byte[] buf = null;
		try {
	        // Convert base64 string to a byte array
	        buf = new sun.misc.BASE64Decoder().decodeBuffer(base64);
	    } catch (Exception e) {
	    }

		return new String(buf);
	}
	
	/**
	 * @param cadena a convertir a double
	 * 
	 * return double -> double correpondiente a la cadena o 0.00 si da error de conversion
	 */
	public static double convertDouble(String cadena) throws P06BException{
		double retorno = 0.0;
		
		if(cadena != null){
			try{
				retorno = Double.parseDouble(cadena.replaceAll(",","\\."));
			}catch (Exception e){
				retorno = 0.0;
			}
		}		
		return retorno;
	}
	
	
	public static double redondear( double numero, int decimales ) 
	{
	    return Math.round(numero*Math.pow(10,decimales))/Math.pow(10,decimales);
	}
	
	
	/**
	 * @param cadena a convertir a int
	 * 
	 * return int -> int correspondiente a la cadena o 0 si da error de conversion
	 */
	public static int convertInt(String cadena) throws P06BException{
		int retorno = 0;
		
		if(cadena != null){
			try{
				retorno = Integer.parseInt(cadena);
			}catch (Exception e){
				retorno = 0;
			}
		}		
		return retorno;
	}
	
	
	/**
	 * @param campo1 a comparar
	 * @param campo2 a comparar
	 * 
	 * return boolean -> true si los campos son iguales, y false si son distintos
	 */
	public static boolean sonIgualesCamposDEC(String campo1, String campo2) throws P06BException{
		boolean sonIguales = true;
		
		if(campo1 == null && campo2 != null){
			sonIguales = false;
		}else if(campo1 != null && campo2 == null){
			sonIguales = false;
		}else if(campo1 != null && campo2 != null && !campo1.toUpperCase().equals(campo2.toUpperCase())){
			sonIguales = false;
		}
		
		return sonIguales;
	}
	
	
	
	
	
}	